/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.pret.util;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class Graphviz {
    public static final String T_PNG = "-Tpng";
    public static final String T_PS = "-Tps";
    public static final String T_SVG = "-Tsvg";
    public static final String LAYOUT_DOT = "-Kdot";
    public static final String LAYOUT_TWOPI = "-Ktwopi";
    public static final String LAYOUT_FDP = "-Kfdp";
    public static final String LAYOUT_CIRCO = "-Kcirco";
    public static final String LAYOUT_NEATO = "-Kneato";
    private Path command;

    public Graphviz(Path path) {
        this.command = path;
    }

    public int graphViz(Path dot, Path outputDir) {
        return this.graphViz(dot, outputDir, T_PNG, LAYOUT_DOT);
    }

    public int graphViz(Path dot, Path outputDir, String format, String layout) {
        String extension = format.substring(format.indexOf(84) + 1);
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.command.toAbsolutePath().toString());
            args.add(format);
            args.add(layout);
            args.add(dot.toAbsolutePath().toString());
            args.add("-o");
            StringBuilder outputFile = new StringBuilder();
            String filename = dot.getFileName().toString();
            outputFile.append(filename.substring(0, filename.lastIndexOf(46)));
            outputFile.append('.');
            outputFile.append(extension);
            args.add(Paths.get(outputDir.toString(), outputFile.toString()).toString());
            ProcessBuilder pb = new ProcessBuilder(args);
            Process p = pb.start();
            return p.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return 1;
    }
}

