package jp.ac.osaka_u.ist.sel.sairi;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TableRow;
import android.widget.TextView;

public class TimeTableActivity extends Activity implements BusInterface, OnItemSelectedListener {

	int from = 0;
	LinearLayout ttable, ttable2;
	private Spinner sp1;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.timetable);

		Intent intent = getIntent();
		int from = intent.getIntExtra("from", BUS_T);

		ttable = (LinearLayout) findViewById(R.id.ttable2);
		sp1 = (Spinner) findViewById(R.id.spinner1);
		sp1.setSelection(from);
		sp1.setOnItemSelectedListener(this);
	}

	private void changeBusStop(int from) {
		try {
			String line;
			InputStream is;
			int to1 = -1, to2 = -1;
			Resources res = this.getResources();
			switch (from) {
			case BUS_T:
				to1 = BUS_SE;
				to2 = BUS_M;
				is = res.openRawResource(TT1);
				break;
			case BUS_SC:
				to1 = BUS_M;
				to2 = -1;
				is = res.openRawResource(TT1);
				break;
			case BUS_SH:
				to1 = BUS_T;
				to2 = -1;
				is = res.openRawResource(TT2);
				break;
			case BUS_SE:
				to1 = BUS_T;
				to2 = -1;
				is = res.openRawResource(TT2);
				break;
			case BUS_M:
				to1 = BUS_T;
				to2 = -1;
				is = res.openRawResource(TT2);
				break;
			default:
				is = null;
				break;
			}

			BufferedReader br = new BufferedReader(new InputStreamReader(is));
			ttable.removeAllViews();
			int h = 7;
			TableRow tr = addRow(h);
			h++;
			while ((line = br.readLine()) != null) {
				Log.d("BUSTABLE ", "H " + h);
				Log.d("BUSTABLE ", line);
				String[] t = line.split(",");
				if (Integer.parseInt(t[from]) != 0) {
					Log.d("TO1,TO2 ", to1+","+to2);
					if (Integer.parseInt(t[to1]) != 0 || to2 != -1 && Integer.parseInt(t[to2]) != 0) {
						Log.d("TIME ", ""+to2);
						while (Integer.parseInt(t[from]) >= h * 100) {
							ttable.addView(tr);
							View v = new View(this);
							v.setBackgroundColor(R.color.busStop);
							v.setMinimumHeight(1);
							ttable.addView(v);
							tr = addRow(h);
							h++;
						}
						addBus(t, tr, from);
					}

				}

			}
			ttable.addView(tr);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private void addBus(String[] t, TableRow r, int from) {
		Bus bus = new Bus(t);
		TextView busTime = new TextView(this);
		busTime.setText(" " + String.valueOf((Integer.parseInt(t[from]) % 100)));
		busTime.setTextSize(18.0f);
		busTime.setGravity(Gravity.RIGHT);
		busTime.setTextColor(Color.BLACK);
		r.addView(busTime);
		TextView busGo = new TextView(this);
		busGo.setText(getResources().getStringArray(R.array.busGo1)[bus.busGo()]);
		busGo.setTextSize(12.0f);
		busGo.setTextColor(Color.BLACK);
		r.addView(busGo);
	}

	private TableRow addRow(int h) {
		Log.d("TR ", "" + h);
		TableRow l = new TableRow(this);
		TextView time = new TextView(this);
		time.setText(h + ": ");
		time.setTextSize(18.0f);
		time.setGravity(Gravity.RIGHT);
		time.setTextColor(Color.BLUE);
		l.addView(time);
		return l;
	}

	@Override
	public void onItemSelected(AdapterView<?> a, View v, int pos, long id) {
		changeBusStop(pos);		
	}

	@Override
	public void onNothingSelected(AdapterView<?> arg0) {
		// do nothing
		
	}

}
