package jp.ac.osaka_u.ist.sel.sairi;

import android.util.Log;

public class Bus implements BusInterface {
	private int from, to;
	String time[];
	private boolean last;
	
	public Bus(String time[]) {
		this.time = time;
	}

	public Bus(String time[], int from, int to, boolean last) {
		this.time = time;
		this.from = from;
		this.to = to;
		this.last = last;
	}

	public int busGo() {
		Log.d("BUSGO ", time[0] + time[1] + time[2] + time[3] + time[4]);

		if (Integer.valueOf(time[BUS_SC]) != 0) {
			return (Integer.valueOf(time[BUS_M]) != 0) ? BUSGO_MS : BUSGO_S;
		} else if (Integer.valueOf(time[BUS_SH]) != 0) {
			return (Integer.valueOf(time[BUS_M]) != 0) ? BUSGO_TS : BUSGO_T;
		} else {
			Log.d("BUSGO ", "D");
			return (Integer.valueOf(time[BUS_M]) < Integer.valueOf(time[BUS_T])) ? BUSGO_TD : BUSGO_MD;
		}
	}
	
	public int getFromTime(){
		return Integer.valueOf(time[from]);
	}
	
	public int getToTime(){
		return Integer.valueOf(time[to]);
	}
	
	public boolean isLastBus(){
		return last;
	}
}
