//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine.data;

import java.io.Serializable;

/**
 * connecting two files (or projects) WITH direction
 * 
 * @author t-kanda
 * 
 */
public class DirectedEdge implements Serializable {

	private static final long serialVersionUID = -7186408067262861169L;
	private int from;
	private int to;
	private boolean direction;

	/**
	 * create directed edge
	 * 
	 * @param from
	 * @param to
	 */
	public DirectedEdge(int from, int to) {
		this.from = from;
		this.to = to;
		this.direction = true;
	}

	
	public DirectedEdge(int from, int to, boolean direction) {
		this.from = from;
		this.to = to;
		this.direction = direction;
	}

	public int from() {
		return from;
	}

	public int to() {
		return to;
	}
	
	public boolean hasDirection(){
		return direction;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof DirectedEdge)) {
			return false;
		}
		DirectedEdge target = (DirectedEdge) obj;
		if(direction){
			return this.from == target.from && this.to == target.to;
		} else {
			return this.from == target.from && this.to == target.to || this.from == target.to && this.to == target.from;
		}
	}

	@Override
	public int hashCode() {
		return from + to * 43;
	}

	@Override
	public String toString() {
		return from + "->" + to;
	}
}