//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine.diff;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

import jp.ac.osaka_u.ist.sel.pret.util.EncodeDetector;
import jp.ac.osaka_u.ist.sel.t_kanda.tkdiff.SED;

//Similarity(A, B) = |AB| / |AB|

/**
 * calc similarity using LCS countor
 * 
 * @author t-kanda
 * 
 */
public class NKLCS extends ADiffCmd {

	private List<String> sA;
	private List<String> sB;

	@Override
	public void set(Path file1, Path file2) {
		this.sA = listLines(file1);
		this.sB = listLines(file2);
		calc();
	}

	public void set(List<String> sA, Path file2) {
		this.sA = sA;
		this.sB = listLines(file2);
		calc();
	}

	/**
	 * Similarity(A, B) = |AB| / |AB|<br>
	 * skip blanks
	 */

	protected void calc() {
		SED sed = new SED();
		int diff = sed.diff(sA, sB);

		int nUnionAB2 = sA.size() + sB.size() + diff;
		int nIntersectionAB2 = sA.size() + sB.size() - diff;

		sim = (float) nIntersectionAB2 / nUnionAB2;
		lcs = nIntersectionAB2 / 2;
		add = sB.size() - lcs;
		del = sA.size() - lcs;
	}

	public static List<String> listLines(Path path) {
		try {
			List<String> result = new ArrayList<>();
			for (String s : Files.readAllLines(path, EncodeDetector.charset(path))) {
				s = s.replaceAll("[ \t]", "");
				if (s.length() > 0) {
					result.add(s);
				}
			}
			return result;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return new ArrayList<>();
	}

}
