grammar Java;
options {
	backtrack=true; 
	memoize=true;
	output = AST;
	ASTLabelType = CommonTree;
	
	}

tokens{
	FLOAT;ENUMCONST;ENUMDEC;INTERFACEDEC;SEL;HEX;DECIMAL;OCTAL;METHODDEC;METHODID;CHAR;STRING;IDS;ADDITIVE;ASSIGN;VARID;ID;QNAME;METHODNAME;TYPE;CBD;CLASSID;DECLARATEDID;IMPORT;FORMALPARAM;
	} 
@header {
	package jp.ac.osaka_u.ist.sel.t_kanda.visidi.tkreduce;
	
	import java.io.Writer;
	import java.io.FileWriter;
	import java.io.IOException;
	import java.io.File;
	import java.util.Stack;
	import java.util.Collections;
	
	import diffevol.util.EncodeDetector;
	
}

@lexer::header {
	package jp.ac.osaka_u.ist.sel.t_kanda.visidi.tkreduce;
}

@lexer::members {
    protected boolean enumIsKeyword = true;
    protected boolean assertIsKeyword = true;
}

@members{
	private Token lastToken;
	 
	public String getErrorMessage(RecognitionException e, String[] tokenNames) {
		List stack = getRuleInvocationStack(e, this.getClass().getName());
		String msg = null;
		if ( e instanceof NoViableAltException ) {
			NoViableAltException nvae = (NoViableAltException)e;
			msg = " no viable alt; token="+e.token+
			" (decision=" + nvae.decisionNumber+
			" state " + nvae.stateNumber + ")" +
			" decision=<<"+nvae.grammarDecisionDescription+">>";
		} else {
			msg = super.getErrorMessage(e, tokenNames);
		}
		return stack+" "+msg;
	}
	public String getTokenErrorDisplay(Token t) {
		return t.toString();
	}
	
	/**
	* My
	*/
    public static ArrayList<TokenInfo> getItems(String inputJavaSourceFileName) {
    	ArrayList<TokenInfo> items = readIdentifiers(inputJavaSourceFileName, EncodeDetector.detect(new File(inputJavaSourceFileName)));
    	return items;
    }
    
    private int expId=0;
    private int vdId = 0;
    
    public static boolean processFile(String inputJavaSourceFileName, String outputFileName) {    	
		File f = new File(outputFileName);
		if (f.exists()) {
			f.delete();
		}
		
		ArrayList<TokenInfo> items = readIdentifiers(inputJavaSourceFileName, EncodeDetector.detect(f));
		if (items != null) {
			try {
				Writer w = new FileWriter(f);
				for (int i=0; i<items.size(); ++i) {
					w.write(items.get(i).toString());
				}
				w.close();
	       		return true;
			} catch (IOException e) {
	        	e.printStackTrace();
    	    	return false;
    	    }
        } else {
        	return false;
        }
	}
	
	public static ArrayList<TokenInfo> readIdentifiers(String inputJavaSourceFileName, String charset) {
		
			try {
				ANTLRFileStream in = new ANTLRFileStream(inputJavaSourceFileName, charset);
				JavaLexer lexer = new JavaLexer(in);
				CommonTokenStream tokens = new CommonTokenStream(lexer);
				JavaParser parser = new JavaParser(tokens);
	            parser.prog();
				//Collections.sort(parser.items);
	            return parser.items;
	        } catch (IOException e) {
	        	e.printStackTrace();
	        } catch (RecognitionException e) {
	            e.printStackTrace();
	        }
	    return null;
	}

	/**
	 * The main method to process a file.
	 */

	
	private ArrayList<TokenInfo> items = new ArrayList<TokenInfo>(65536);
	
	/*
	 * CharPositionInLine() "+1" make ANTLR's char position (starting with 0) 
	 * compatible with CCFinder's one (starting with 1).
	 */
	private void output(String tokenString, Token t, short type) {
		items.add(new TokenInfo(tokenString, type, t.getLine(), t.getCharPositionInLine()+1, t.getTokenIndex()));
	}
	
	private void output(Token t, short type) {
		lastToken = t;
		output(t.getText(), t, type);
	}
	
	
	
	
	private Stack<List<CategorizedToken>> postponedOutput = new Stack<List<CategorizedToken>>();

	private void startPostpone() {
		postponedOutput.push(new ArrayList<CategorizedToken>());
	}

	private void postpone(Token t, short type) {
		postponedOutput.peek().add(new CategorizedToken(t, type));
	}
	
	private int getPostponedTokenCount() {
		return postponedOutput.peek().size();
	}
	
	private void cancel(Token t) {
		List<CategorizedToken> tokens = postponedOutput.peek();
		for (int i=0; i<tokens.size(); ++i) {
			CategorizedToken token = tokens.get(i); 
			if (token.sameToken(t)) {
				tokens.remove(token);
				break;
			}
		}
	}
	
	private void replace(Token t, short type) {
		List<CategorizedToken> tokens = postponedOutput.peek();
		for (int i=0; i<tokens.size(); ++i) {
			CategorizedToken token = tokens.get(i); 
			if (token.sameToken(t)) {
				token.replaceType(type);
				break;
			}
		}
	}
	
	private void commit() {
		List<CategorizedToken> tokens = postponedOutput.pop();
		for (int i=0; i<tokens.size(); ++i) {
			CategorizedToken t = tokens.get(i);
			output(t.getToken(), t.getType()); 
		}
	}
	
	private Token getLastToken() {
		return lastToken;
	}
	
	private static class CategorizedToken {
		private Token token;
		private short type;
		
		public CategorizedToken(Token t, short type) {
			this.token = t;
			this.type = type;
		}
		public boolean sameToken(Token t) {
			return this.token == t;
		}
		public void replaceType(short type) {
			this.type = type;
		}
		public Token getToken() {
			return this.token;
		}
		public short getType() {
			return this.type;
		} 
	}

	
}

// starting point for parsing a java file
/* The annotations are separated out to make parsing faster, but must be associated with
   a packageDeclaration or a typeDeclaration (and not an empty one). */
   
prog
    :	compilationUnit  
    	;
compilationUnit
    :   annotations
        (   packageDeclaration importDeclaration* typeDeclaration*
        |   classOrInterfaceDeclaration typeDeclaration*
        )
    |   packageDeclaration? importDeclaration* typeDeclaration*
    ;

packageDeclaration
    :   'package' packageName ';'
    ;
    
importDeclaration
//    :   'import' 'static'? importName ('.' i='*' { output(i, "imports"); })? ';'
    :   'import' 'static'? importName ('.*')? ';'
    ;
    
typeDeclaration
    :   classOrInterfaceDeclaration
    |   ';'
    ;
    
classOrInterfaceDeclaration
    :   classOrInterfaceModifiers (classDeclaration | interfaceDeclaration)
    ;
    
classOrInterfaceModifiers
    :   classOrInterfaceModifier*
    ;

classOrInterfaceModifier
    :   annotation   // class or interface
    |   'public'     // class or interface
    |   'protected'  // class or interface
    |   'private'    // class or interface
    |   'abstract'   // class or interface
    |   'static'     // class or interface
    |   'final'      // class only -- does not apply to interfaces
    |   'strictfp'   // class or interface
    ;

modifiers
    :   modifier*
    ;

classDeclaration
    :   normalClassDeclaration
    |   enumDeclaration
    ;
    
normalClassDeclaration
//    :   'class' i=Identifier { output(i, "type"); }
    :   'class' Identifier
    	typeParameters?
        ('extends' type)?
        ('implements' typeList)?
        classBody
    ;
    
typeParameters
    :   '<' typeParameter (',' typeParameter)* '>'
    ;

typeParameter
//    :   i=Identifier { output(i, "type"); }
    :   Identifier
    	('extends' typeBound)?
    ;
        
typeBound
    :   type ('&' type)*
    ;

enumDeclaration
//    :   ENUM i=Identifier { output(i, "other"); }
    :   ENUM Identifier
        ('implements' typeList)? enumBody
    ;

enumBody
    :   '{' enumConstants? ','? enumBodyDeclarations? '}'
    ;

enumConstants
    :   enumConstant (',' enumConstant)*
    ;
    
enumConstant
//    :   annotations? i=Identifier { output(i, "other"); }
    :   annotations? Identifier
    	arguments? classBody?
    ;
    
enumBodyDeclarations
    :   ';' (classBodyDeclaration)*
    ;
    
interfaceDeclaration
    :   normalInterfaceDeclaration
    |   annotationTypeDeclaration
    ;
    
normalInterfaceDeclaration
//    :   'interface' i=Identifier { output(i, "type"); }
    :   'interface'  Identifier
   	   	typeParameters? ('extends' typeList)? interfaceBody
    ;
    
typeList
    :   type (',' type)*
    ;
    
classBody
    :   i='{' { output(i, TokenInfo.TYPE_CLS_BGN); } classBodyDeclaration* k='}' { output(k, TokenInfo.TYPE_CLS_END); }	    	
    ;
    
interfaceBody
    :   '{' interfaceBodyDeclaration* '}'
    ;

classBodyDeclaration
    :   ';'
    |   'static'? block
    |   modifiers memberDecl
    ;
    
memberDecl
    :   genericMethodOrConstructorDecl
    |   memberDeclaration
//    |   v='void' {output(v, "type"); }  i=Identifier { output(i, TokenInfo.TYPE_METHODDECL); } voidMethodDeclaratorRest 
//    |   i=Identifier { output(i, "type"); /* constructor name == type name */ }  constructorDeclaratorRest  
    |   'void'  i=Identifier { output(i, TokenInfo.TYPE_METHODDECL); } k=voidMethodDeclaratorRest { output(k.stop, TokenInfo.TYPE_METHODEND); }
    |   Identifier constructorDeclaratorRest  
    |   interfaceDeclaration
    |   classDeclaration
    ;
    
memberDeclaration
    :   type (methodDeclaration | fieldDeclaration)
    ;

genericMethodOrConstructorDecl
    :   typeParameters genericMethodOrConstructorRest
    ;
    
genericMethodOrConstructorRest
//    :   (type | i = 'void' { output(i, "type"); } )
    :   (type | 'void')  
        m=Identifier { output(m, TokenInfo.TYPE_METHODDECL); } 
        k = methodDeclaratorRest  {output(k.stop, TokenInfo.TYPE_METHODEND); }

//    |   i=Identifier { output(i, "type"); /* constructor name == type name */ }
    |   Identifier
        constructorDeclaratorRest

    ;

methodDeclaration
    :  i=Identifier { output(i, TokenInfo.TYPE_METHODDECL); } k = methodDeclaratorRest { output(k.stop, TokenInfo.TYPE_METHODEND); }
    ;

fieldDeclaration
    :   variableDeclarators ';'
    ;
        
interfaceBodyDeclaration
    :   modifiers interfaceMemberDecl
    |   ';'
    ;

interfaceMemberDecl
    :   interfaceMethodOrFieldDecl
    |   interfaceGenericMethodDecl
//    |   i='void' { output(i, "type"); }
    |   'void'
//        i=Identifier { output(i, "method"); }
        Identifier
    	voidInterfaceMethodDeclaratorRest
    |   interfaceDeclaration
    |   classDeclaration
    ;
    
interfaceMethodOrFieldDecl
//    :   type i=Identifier { output(i, "method"); }
    :   type Identifier
    	interfaceMethodOrFieldRest
    ;
    
interfaceMethodOrFieldRest
    :   constantDeclaratorsRest ';'
    |   interfaceMethodDeclaratorRest
    ;
    
methodDeclaratorRest
    :   formalParameters ('[' ']')*
        ('throws' qualifiedNameListForThrows)?
        (   methodBody
        |   ';'
        )
    ;
    
voidMethodDeclaratorRest
    :   formalParameters ('throws' qualifiedNameListForThrows)?
        (   methodBody
        |   ';'
        )
    ;
    
interfaceMethodDeclaratorRest
    :   formalParameters ('[' ']')* ('throws' qualifiedNameListForThrows)? ';'
    ;
    
interfaceGenericMethodDecl
//    :   typeParameters (type | i = 'void' { output(i, "type"); } ) 
    :   typeParameters (type | 'void' ) 
//        i=Identifier { output(i, "method"); }
        Identifier 
        interfaceMethodDeclaratorRest
    ;
    
voidInterfaceMethodDeclaratorRest
    :   formalParameters ('throws' qualifiedNameListForThrows)? ';'
    ;
    
constructorDeclaratorRest
    :   formalParameters ('throws' qualifiedNameListForThrows)? constructorBody
    ;

constantDeclarator
//    :   i = Identifier { output(i, "other"); }
    :   Identifier
        constantDeclaratorRest
    ;
    
variableDeclarators
    :   variableDeclarator (',' variableDeclarator)*
    ;

variableDeclarator
    :   variableDeclaratorId 
    |   e1 = variableDeclaratorId
        '='
        e2 = variableInitializer { output(e1.start, TokenInfo.TYPE_EXP_BGN); output(e2.stop, TokenInfo.TYPE_EXP_END); expId++; }
    ;
        
constantDeclaratorsRest
    :   constantDeclaratorRest (',' constantDeclarator)*
    ;

constantDeclaratorRest
    :   ('[' ']')* '=' variableInitializer
    ;
    
variableDeclaratorId
    :   i = Identifier { output(i, TokenInfo.TYPE_VAR); } ('[' ']')*
    ;

variableInitializer
    :   arrayInitializer
    |   expression
    ;
        
arrayInitializer
//    :    i = '{' { output("arrayIniBegin", i, "arrayIniBegin"); }
    :    '{'
		(variableInitializer (',' variableInitializer)* (',')? )? 
//		i = '}' { output("arrayIniEnd", i, "arrayIniEnd"); }    ;
		'}';

modifier
    :   annotation
    |   'public'
    |   'protected'
    |   'private'
    |   'static'
    |   'abstract'
    |   'final'
    |   'native'
    |   'synchronized'
    |   'transient'
    |   'volatile'
    |   'strictfp'
    ;

packageOrTypeName
    :   qualifiedName
    ;

enumConstantName
//    :   i = Identifier { output(i, "other"); }
    :   Identifier
    ;

typeName
    :   qualifiedName
    ;

type
	:	classOrInterfaceType ('[' ']')*
	|	primitiveType ('[' ']')*
	;

classOrInterfaceType
//	:	i=Identifier { startPostpone(); postpone(i, "packageOrClassName"); }
//	    typeArguments? ('.'  j=Identifier { postpone(j, "packageOrClassName"); } typeArguments? )*
//	    { if (j==null) replace(i, "type"); 
//	      else replace(j, "type");
//	      commit();
//	    }
   	:	Identifier typeArguments? ('.' Identifier typeArguments? )*
	;
	
primitiveType
//    :   i = 'boolean' { output(i, "type"); }
//    |   i = 'char'    { output(i, "type"); }
//    |   i = 'byte'    { output(i, "type"); }
//    |   i = 'short'   { output(i, "type"); }
//    |   i = 'int'     { output(i, "type"); }
//    |   i = 'long'    { output(i, "type"); }
//    |   i = 'float'   { output(i, "type"); }
//    |   i = 'double'  { output(i, "type"); }
    :   'boolean'
    |   'char'
    |   'byte'
    |   'short'
    |   'int'
    |   'long'
    |   'float'
    |   'double'
    ;

variableModifier
    :   'final'
    |   annotation
    ;

typeArguments
    :   '<' typeArgument (',' typeArgument)* '>'
    ;
    
typeArgument
    :   type
    |   '?' (('extends' | 'super') type)?
    ;
    
qualifiedNameListForThrows
    :   qualifiedExceptionName (',' qualifiedExceptionName)*
    ;

formalParameters
    :   '(' formalParameterDecls? ')'
    	    ;
    
formalParameterDecls
    :   variableModifiers type formalParameterDeclsRest
    ;
    
formalParameterDeclsRest
    :   variableDeclaratorId (',' formalParameterDecls)?
    |   '...' variableDeclaratorId
    ;
    
methodBody
    :   block
    ;

constructorBody
    :   '{' explicitConstructorInvocation? blockStatement* '}'
    ;

explicitConstructorInvocation
    :   nonWildcardTypeArguments? ('this' | 'super') arguments ';'
    |   primary '.' nonWildcardTypeArguments? 'super' arguments ';'
    ;


qualifiedName 
//    :   i = Identifier { output(i, "packageOrClassName"); }
//    	   	('.' i = Identifier { output(i, "packageOrClassName"); }	)*
    :    Identifier	('.' Identifier)*
    ;

qualifiedExceptionName
//    :   i = Identifier { startPostpone(); postpone(i, "packageOrClassName"); }
//    	   	('.' j = Identifier { output(j, "packageOrClassName"); } )*
    :   Identifier ('.' Identifier)*
//    	{ if (j == null) replace(i, "type"); 
//    	  else replace(j, "type");
//    	  commit();
//    	}
    ;

packageName
//    :   i = Identifier { output(i, "package"); }
//    	   	('.' i = Identifier { output(i, "packages"); } )*
    :    Identifier	('.' Identifier)*
    ;    
importName
//    :   i = Identifier { output(i, "import"); }
//    	   	('.' i = Identifier { output(i, "imports"); } )*
    :    Identifier	('.' Identifier)*
    ;
    
literal 
    :   integerLiteral
//    |   i =  FloatingPointLiteral  { output(i, "literal"); }
//    |   i = CharacterLiteral { output(i, "literal"); }
//    |   i = StringLiteral  { output(i, "literal"); }
//    |   FloatingPointLiteral
//    |   CharacterLiteral
//    |   StringLiteral
    |   floatingPointLiteral
    |   i = CharacterLiteral { output(i, TokenInfo.TYPE_LITERAL_CHAR); }
    |   i = StringLiteral  { output(i, TokenInfo.TYPE_LITERAL_STRING); }
    |   booleanLiteral 
    |   k = booleanLiteral  { output(k.start, TokenInfo.TYPE_LITERAL_BOOL); }
    |   i = 'null' { output(i, TokenInfo.TYPE_NULL); }
//    |   'null'
    ;

integerLiteral
    :   i = HexLiteral { output(i, TokenInfo.TYPE_LITERAL_INT); }
    |   i = OctalLiteral { output(i, TokenInfo.TYPE_LITERAL_INT); }
    |   i = DecimalLiteral { output(i, TokenInfo.TYPE_LITERAL_INT); }
    ;

floatingPointLiteral
    :   i = DecimalFloatingPointLiteral { output(i, TokenInfo.TYPE_LITERAL_FLOAT); }
    |   i = HexadecimalFloatingPointLiteral { output(i, TokenInfo.TYPE_LITERAL_FLOAT); }
    ;

booleanLiteral
    :   i = 'true' { output(i, TokenInfo.TYPE_LITERAL_BOOL); }
    |   i = 'false' { output(i, TokenInfo.TYPE_LITERAL_BOOL); }
    ;

// ANNOTATIONS

annotations
    :   annotation+
    ;

annotation
//    :   i='@' { output(i, "annotationBegin"); } annotationName ( '(' ( elementValuePairs | elementValue )? k=')' )? 
//    		{ if (k != null) output(k, "annotationEnd");
//    			else output(getLastToken(), "annotationEnd"); 
//    		}
//    ;
    :   '@' annotationName ( '(' ( elementValuePairs | elementValue )? ')' )? 
    ;
    
annotationName
//    : i = Identifier { output(i, "annotation"); } ('.' i = Identifier { output(i, "annotations"); })*
    : Identifier ('.' Identifier)*
    ;

elementValuePairs
    :   elementValuePair (',' elementValuePair)*
    ;

elementValuePair
//    :   i = Identifier { output(i, "other"); } '=' elementValue
    :   Identifier '=' elementValue
    ;
    
elementValue
    :   conditionalExpression
    |   annotation
    |   elementValueArrayInitializer
    ;
    
elementValueArrayInitializer
    :   '{' (elementValue (',' elementValue)*)? (',')? '}'
    ;
    
annotationTypeDeclaration
//    :   '@' 'interface' i = Identifier { output(i, "other"); } annotationTypeBody
    :   '@' 'interface' Identifier annotationTypeBody
    ;
    
annotationTypeBody
    :   '{' (annotationTypeElementDeclaration)* '}'
    ;
    
annotationTypeElementDeclaration
    :   modifiers annotationTypeElementRest
    ;
    
annotationTypeElementRest
    :   type annotationMethodOrConstantRest ';'
    |   normalClassDeclaration ';'?
    |   normalInterfaceDeclaration ';'?
    |   enumDeclaration ';'?
    |   annotationTypeDeclaration ';'?
    ;
    
annotationMethodOrConstantRest
    :   annotationMethodRest
    |   annotationConstantRest
    ;
    
annotationMethodRest
//    :   i = Identifier { output(i, "other"); }  '(' ')' defaultValue?
    :   Identifier '(' ')' defaultValue?    	        
    ;
    
annotationConstantRest
    :   variableDeclarators
    ;
    
defaultValue
    :   'default' elementValue
    ;

// STATEMENTS / BLOCKS

block
    :   '{' blockStatement* '}'
    ;
    
blockStatement
    :   localVariableDeclarationStatement
    |   classOrInterfaceDeclaration
    |   statement
    ;
    
localVariableDeclarationStatement
    :    localVariableDeclaration ';'
    ;

localVariableDeclaration
    :   variableModifiers type variableDeclarators
    ;
    
variableModifiers
    :   variableModifier*
    ;



statement
    : block
    |   ASSERT expression (':' expression)? ';'
    |   'if' parExpression statement (options {k=1;}:'else' statement)?
    |   'for' '(' forControl ')' statement
    |   'while' parExpression statement
    |   'do' statement 'while' parExpression ';'
    |   'try' block
        ( catches 'finally' block
        | catches
        |   'finally' block
        )
    |   'switch' parExpression '{' switchBlockStatementGroups '}'
    |   'synchronized' parExpression block
    |   'return' expression? ';'
    |   'throw' expression ';'
//    |   'break' i = Identifier? { if(i != null) output(i, "label"); } ';'
//    |   'continue' i = Identifier? { if(i != null) output(i, "label"); }';'
    |   'break' Identifier? ';'
    |   'continue' Identifier? ';'
    |   ';' 
    |   statementExpression ';'
//    |   i = Identifier  { output(i, "label"); } ':' statement
    |   Identifier ':' statement
    ;
    
catches
    :   catchClause (catchClause)*
    ;
    
catchClause
    :   'catch' '(' formalParameter ')' block
    ;

formalParameter
    :   variableModifiers type variableDeclaratorId
    ;
        
switchBlockStatementGroups
    :   (switchBlockStatementGroup)*
    ;
    
/* The change here (switchLabel -> switchLabel+) technically makes this grammar
   ambiguous; but with appropriately greedy parsing it yields the most
   appropriate AST, one in which each group, except possibly the last one, has
   labels and statements. */
switchBlockStatementGroup
    :   switchLabel+ blockStatement*
    ;
    
switchLabel
    :   'case' constantExpression ':'
    |   'case' enumConstantName ':'
    |   'default' ':'
    ;
    
forControl
options {k=3;} // be efficient for common case: for (ID ID : ID) ...
    :   enhancedForControl
    |   forInit? ';' expression? ';' forUpdate?
    ;

forInit
    :   localVariableDeclaration
    |   expressionList
    ;
    
enhancedForControl
    :   variableModifiers type i = Identifier { output(i, TokenInfo.TYPE_VAR); } ':' expression
    ;

forUpdate
    :   expressionList
    ;

// EXPRESSIONS

parExpression
    :   '(' expression ')'
    ;
    
expressionList
    :   expression (',' expression)*
    ;

statementExpression
    :   expression
    ;
    
constantExpression
    :   expression
    ;
    
expression
    //:  conditionalExpression (assignmentOperator expression)?
	: e = exp2 { output(e.start, TokenInfo.TYPE_EXP_BGN); output(e.stop, TokenInfo.TYPE_EXP_END); }
    ;
    
exp2
	//: e = conditionalExpression { output("", e.start, "expc_begin"); output("", e.stop, "expc_end"); } (assignmentOperator expression)?
	: e = conditionalExpression (assignmentOperator expression)?
	;
    
assignmentOperator
    :   '='
    |   '+='
    |   '-='
    |   '*='
    |   '/='
    |   '&='
    |   '|='
    |   '^='
    |   '%='
    |   ('<' '<' '=')=> t1='<' t2='<' t3='=' 
        { $t1.getLine() == $t2.getLine() &&
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() && 
          $t2.getLine() == $t3.getLine() && 
          $t2.getCharPositionInLine() + 1 == $t3.getCharPositionInLine() }?
    |   ('>' '>' '>' '=')=> t1='>' t2='>' t3='>' t4='='
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() &&
          $t2.getLine() == $t3.getLine() && 
          $t2.getCharPositionInLine() + 1 == $t3.getCharPositionInLine() &&
          $t3.getLine() == $t4.getLine() && 
          $t3.getCharPositionInLine() + 1 == $t4.getCharPositionInLine() }?
    |   ('>' '>' '=')=> t1='>' t2='>' t3='='
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() && 
          $t2.getLine() == $t3.getLine() && 
          $t2.getCharPositionInLine() + 1 == $t3.getCharPositionInLine() }?
    ;

conditionalExpression
    :   conditionalOrExpression ( '?' expression ':' expression )?
    ;

conditionalOrExpression
    :   conditionalAndExpression ( '||' conditionalAndExpression )*
    ;

conditionalAndExpression
    :   inclusiveOrExpression ( '&&' inclusiveOrExpression )*
    ;

inclusiveOrExpression
    :   exclusiveOrExpression ( '|' exclusiveOrExpression )*
    ;

exclusiveOrExpression
    :   andExpression ( '^' andExpression )*
    ;

andExpression
    :   equalityExpression ( '&' equalityExpression )*
    ;

equalityExpression
    :   instanceOfExpression ( ('==' | '!=') instanceOfExpression )*
    ;

instanceOfExpression
    :   relationalExpression ('instanceof' type)?
    ;

relationalExpression
    :   shiftExpression ( relationalOp shiftExpression )*
    ;
    
relationalOp
    :   ('<' '=')=> t1='<' t2='=' 
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() }?
    |   ('>' '=')=> t1='>' t2='=' 
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() }?
    |   '<' 
    |   '>' 
    ;

shiftExpression
    :   additiveExpression ( shiftOp additiveExpression )*
    ;

shiftOp
    :   ('<' '<')=> t1='<' t2='<' 
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() }?
    |   ('>' '>' '>')=> t1='>' t2='>' t3='>' 
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() &&
          $t2.getLine() == $t3.getLine() && 
          $t2.getCharPositionInLine() + 1 == $t3.getCharPositionInLine() }?
    |   ('>' '>')=> t1='>' t2='>'
        { $t1.getLine() == $t2.getLine() && 
          $t1.getCharPositionInLine() + 1 == $t2.getCharPositionInLine() }?
    ;


additiveExpression
    :   multiplicativeExpression ( ('+' | '-') multiplicativeExpression )*   
    ;

multiplicativeExpression
    :   unaryExpression ( ( '*' | '/' | '%' ) unaryExpression )*
    ;
    
unaryExpression
    :   '+' unaryExpression
    |   '-' unaryExpression
    |   '++' unaryExpression
    |   '--' unaryExpression
    |   unaryExpressionNotPlusMinus
    ;

unaryExpressionNotPlusMinus
    :   '~' unaryExpression
    |   '!' unaryExpression
    |   castExpression
    |   primary selector* ('++' | '--')?
    ;

castExpression
    :  '(' primitiveType ')' unaryExpression
    |  '(' (type | expression) ')' unaryExpressionNotPlusMinus
    ;

primary
    :   parExpression
//    |   i = 'this' { startPostpone(); postpone(i, "this"); } ('.' j=Identifier { postpone(j, "receiverChain"); })* k=identifierSuffix? 
    |   i = 'this' { startPostpone(); postpone(i, TokenInfo.TYPE_N); } ('.' j=Identifier { postpone(j, TokenInfo.TYPE_RCHAIN); })* k=identifierSuffix? 
        { 
        	/* According to the return value of identifierSuffix, 
        	   update the type name for the last identifier.  */
        	if (k != null) {
	       	    if (j == null) { /* this(), this.<T>method() or something */
       	    		replace(i, $identifierSuffix.type);
	       	    } else {
	       	    	//if ($identifierSuffix.type.equals("method") && getPostponedTokenCount() > 2) {
	       	    	if ($identifierSuffix.type==TokenInfo.TYPE_METHOD && getPostponedTokenCount() > 2) {
	       	    		/* "this" is not ignored For "this.j1()", but ignored for this.j1.j2() */
		       	    	cancel(i); /* Ignore "this" for explicit reference of method/field */ 
	       	    	}
	       	    	replace(j, $identifierSuffix.type);
	       	    }
	       	} else {
     			/* If there are no identifierSuffix, the last identifier must be a variable. */
    			if (j==null) {
    				replace(i, TokenInfo.TYPE_VAR);
    			} else {
    				cancel(i);  /* Ignore "this" for explicit field reference */
    				replace(j, TokenInfo.TYPE_VAR);
    			}
	       	}
        	commit();
        }  
    |   'super' superSuffix
    |   literal
    |   'new' creator
//        |   i = Identifier { startPostpone(); postpone(i, "receiverChain"); } ('.' j = Identifier { postpone(j, "receiverChain"); } )* k=identifierSuffix?
        |   i = Identifier { startPostpone(); postpone(i, TokenInfo.TYPE_RCHAIN); } ('.' j = Identifier { postpone(j, TokenInfo.TYPE_RCHAIN); } )* k=identifierSuffix?
    	{
        	/* According to the return value of identifierSuffix, 
        	   update the type name for the last identifier.  */
        	if (k != null) {        	
	       	    if (j == null) {
	       	    	short identType = $identifierSuffix.type; 
	       	    	//if (identType.equals("method")) {
	       	    	//	identType = "methodWithoutReceiver";
	       	    	//}
	       	    	replace(i, identType);
	       	    } else {
	       	    	replace(j, $identifierSuffix.type);
	       	    }
	       	} else {
     			/* If there are no identifierSuffix, the last identifier must be a variable. */
    			if (j==null) replace(i, TokenInfo.TYPE_VAR);
    			else replace(j, TokenInfo.TYPE_VAR);
	       	}
        	commit();
    	}
    |   primitiveType ('[' ']')* '.' 'class'
//    |   i = 'void' { output(i, "type"); } '.' 'class'
    |  'void' '.' 'class'
    ;

identifierSuffix returns [short type, short previous ]
//    :   ('[' ']')+ '.' 'class' { $type="type"; }
//    |   ('[' expression ']')+  { $type"var"; } // can also be matched by selector, but do here
//    |   arguments              { $type="method"; }
//    |   '.' 'class'            { $type="type"; }
//    |   '.' explicitGenericInvocation { $type="receiver"; }
//    |   '.' 'this'             { $type="type"; }
//    |   '.' 'super' arguments  { $type="type"; }
//    |   '.' 'new' innerCreator { $type="var"; }
    :   ('[' ']')+ '.' 'class' { $type=TokenInfo.TYPE_TYPE; }
    |   ('[' expression ']')+  { $type=TokenInfo.TYPE_VAR; } // can also be matched by selector, but do here
    |   arguments              { $type=TokenInfo.TYPE_METHOD; }
    |   '.' 'class'            { $type=TokenInfo.TYPE_TYPE; }
    |   '.' explicitGenericInvocation { $type=TokenInfo.TYPE_RECEIVER; }
    |   '.' 'this'             { $type=TokenInfo.TYPE_TYPE; }
    |   '.' 'super' arguments  { $type=TokenInfo.TYPE_TYPE; }
    |   '.' 'new' innerCreator { $type=TokenInfo.TYPE_VAR; }
    ;

creator
    :   nonWildcardTypeArguments createdName classCreatorRest
    |   createdName (arrayCreatorRest | classCreatorRest)
    ;

createdName
    :   classOrInterfaceType
    |   primitiveType
    ;
    
innerCreator
//    :   nonWildcardTypeArguments? i=Identifier{ output(i, "type"); } classCreatorRest
    :   nonWildcardTypeArguments? Identifier classCreatorRest
    ;

arrayCreatorRest
    :   '['
        (   ']' ('[' ']')* arrayInitializer
        |   expression ']' ('[' expression ']')* ('[' ']')*
        )
    ;

classCreatorRest
    :   arguments classBody?
    ;
    
explicitGenericInvocation
//    :   nonWildcardTypeArguments i = Identifier { output(i, "method"); } arguments
    :   nonWildcardTypeArguments Identifier arguments
    ;
    
nonWildcardTypeArguments
    :   '<' typeList '>'
    ;
    
selector    // a method chain is a sequence of selectors
//    :   '.' i=Identifier arguments  { output(i, "method"); } 
//    |   '.' i=Identifier  { output(i, "selectorChain"); } 
    :   '.' Identifier arguments
    |   '.' Identifier
    |   '.' 'this'
    |   '.' 'super' superSuffix
    |   '.' 'new' innerCreator
    |   '[' expression ']'
    ;
    
superSuffix
    :   arguments
//    |   '.' i = Identifier j=arguments? { if (j!=null) output(i, "method"); else output(i, "var"); }  /* "C.super.f" is used to access a field defined in a super class. */
    |   '.' i = Identifier j=arguments? { if (j==null) output(i, TokenInfo.TYPE_VAR); }  /* "C.super.f" is used to access a field defined in a super class. */
    ;

arguments
//    :   i='(' { output(i, "argumentsLeft"); } expressionList? i=')' { output(i, "argumentsRight"); } 
    :   '(' expressionList? ')'
    ;

// LEXER

HexLiteral : '0' ('x'|'X') HexDigit+ IntegerTypeSuffix? ;

DecimalLiteral : ('0' | '1'..'9' '0'..'9'*) IntegerTypeSuffix? ;

OctalLiteral : '0' ('0'..'7')+ IntegerTypeSuffix? ;

fragment
HexDigit : ('0'..'9'|'a'..'f'|'A'..'F') ;

fragment
IntegerTypeSuffix : ('l'|'L') ;

DecimalFloatingPointLiteral
    :   ('0'..'9')+ '.' ('0'..'9')* Exponent? FloatTypeSuffix?
    |   '.' ('0'..'9')+ Exponent? FloatTypeSuffix?
    |   ('0'..'9')+ Exponent FloatTypeSuffix?
    |   ('0'..'9')+ FloatTypeSuffix
    ;

HexadecimalFloatingPointLiteral
    :   '0' ('x'|'X') HexDigit+ ('.' HexDigit*)? BinaryExponent FloatTypeSuffix?
    |   '0' ('x'|'X') '.' HexDigit+ BinaryExponent FloatTypeSuffix?
    ;

fragment
Exponent : ('e'|'E') ('+'|'-')? ('0'..'9')+ ;

fragment
BinaryExponent : ('p'|'P') ('+'|'-')? ('0'..'9')+ ;

fragment
FloatTypeSuffix : ('f'|'F'|'d'|'D') ;

CharacterLiteral
    :   '\'' ( EscapeSequence | ~('\''|'\\') ) '\''
    ;

StringLiteral
    :  '"' ( EscapeSequence | ~('\\'|'"') )* '"' ('\\' WS* StringLiteral)*
    ;

fragment
EscapeSequence
    :   '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\')
    |   UnicodeEscape
    |   OctalEscape
    ;

fragment
OctalEscape
    :   '\\' ('0'..'3') ('0'..'7') ('0'..'7')
    |   '\\' ('0'..'7') ('0'..'7')
    |   '\\' ('0'..'7')
    ;

fragment
UnicodeEscape
    :   '\\' 'u' HexDigit HexDigit HexDigit HexDigit
    ;

ENUM:   'enum' { if (!enumIsKeyword) $type=Identifier; }
    ;
    
ASSERT
    :   'assert' {if (!assertIsKeyword) $type=Identifier;}
    ;
    
Identifier 
    :   Letter (Letter|JavaIDDigit)*
    ;

/**I found this char range in JavaCC's grammar, but Letter and Digit overlap.
   Still works, but...
 */
fragment
Letter
    :  '\u0024' |
       '\u0041'..'\u005a' |
       '\u005f' |
       '\u0061'..'\u007a' |
       '\u00c0'..'\u00d6' |
       '\u00d8'..'\u00f6' |
       '\u00f8'..'\u00ff' |
       '\u0100'..'\u1fff' |
       '\u3040'..'\u318f' |
       '\u3300'..'\u337f' |
       '\u3400'..'\u3d2d' |
       '\u4e00'..'\u9fff' |
       '\uf900'..'\ufaff'
    ;

fragment
JavaIDDigit
    :  '\u0030'..'\u0039' |
       '\u0660'..'\u0669' |
       '\u06f0'..'\u06f9' |
       '\u0966'..'\u096f' |
       '\u09e6'..'\u09ef' |
       '\u0a66'..'\u0a6f' |
       '\u0ae6'..'\u0aef' |
       '\u0b66'..'\u0b6f' |
       '\u0be7'..'\u0bef' |
       '\u0c66'..'\u0c6f' |
       '\u0ce6'..'\u0cef' |
       '\u0d66'..'\u0d6f' |
       '\u0e50'..'\u0e59' |
       '\u0ed0'..'\u0ed9' |
       '\u1040'..'\u1049'
   ;

WS  :  (' '|'\r'|'\t'|'\u000C'|'\n') {$channel=HIDDEN;}
    ;

COMMENT
    :  '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;}
    ;

LINE_COMMENT
    : '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}
    ;