//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.engine.data;

import java.util.Set;

public interface ISimilarity {

	/** no similarity value (haven't calculated) */
	public static final float NOVALUE = -2.2F;

	/** no diff value */
	public static final int NODIFF = Integer.MIN_VALUE;

	/**
	 * get similarity
	 * 
	 * @param edge
	 * @return similarity
	 */
	float getSimilarity(Edge edge);

	/**
	 * set similarity
	 * 
	 * @param edge
	 * @param similarity
	 */
	void setSimilarity(Edge edge, float similarity);

	void setDiff(Edge edge, String diff);

	Set<Edge> edges();

	String getDiff(Edge edge);

	int getDiffSize(Edge edge);

	int getDiffSize(int v, int u);

	void setIncDec(Edge edge, int add, int del);

	int getDec(Edge edge);

	int getInc(Edge edge);

}
