//PRET-Extractor
//Copyright (c) 2013 Tetsuya Kanda
//
//http://sel.ist.osaka-u.ac.jp/pret/
//
//Permission is hereby granted, free of charge, to any person obtaining
//a copy of this software and associated documentation files (the
//"Software"), to deal in the Software without restriction, including
//without limitation the rights to use, copy, modify, merge, publish,
//distribute, sublicense, and/or sell copies of the Software, and to
//permit persons to whom the Software is furnished to do so, subject to
//the following conditions:
//
//The above copyright notice and this permission notice shall be
//included in all copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
//OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
//WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

package jp.ac.osaka_u.ist.sel.pret.util;

import gnu.trove.set.hash.THashSet;

import java.util.Collection;
import java.util.Set;

public class PRF_t<T> {

	private final Collection<T> correct;
	private Collection<T> answer, tp, fp, fn;

	public PRF_t(Collection<T> correct) {
		this.correct = new THashSet<>(correct);
	}

	public void setAnswer(Collection<T> answer) {
		this.answer = new THashSet<>(answer);

		tp = new THashSet<>(correct);
		tp.retainAll(answer);

		fp = new THashSet<>(answer);
		fp.removeAll(correct);

		fn = new THashSet<>(correct);
		fn.removeAll(answer);
	}

	public Set<T> getAnswer() {
		return new THashSet<>(answer);
	}

	public Set<T> truePositiveSet() {
		return new THashSet<>(tp);
	}

	public int truePositive() {
		return tp.size();
	}

	public Set<T> falsePositiveSet() {
		return new THashSet<>(fp);
	}

	public int falsePositive() {
		return fp.size();
	}

	public Set<T> falseNegativeSet() {
		return new THashSet<>(fn);
	}

	public int falseNegative() {
		return fn.size();
	}

	public double precision() {
		return (double) truePositive() / (truePositive() + falsePositive());
	}

	public double recall() {
		return (double) truePositive() / (truePositive() + falseNegative());
	}

	public double f() {
		return 2 / (1 / recall() + 1 / precision());
	}
}